/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.chat;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.hooks.client.screen.ScreenHooks;
import dev.architectury.platform.Platform;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.chat.ChatAuthImpl;
import net.creeperhost.minetogether.chat.ChatStatistics;
import net.creeperhost.minetogether.chat.ChatTarget;
import net.creeperhost.minetogether.chat.gui.ChatScreen;
import net.creeperhost.minetogether.chat.gui.FriendsListScreen;
import net.creeperhost.minetogether.chat.ingame.MTChatComponent;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.gui.SettingsScreen;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.MutedUserList;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.polylib.gui.IconButton;
import net.creeperhost.minetogether.polylib.gui.SimpleToast;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogetherChat {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ChatAuthImpl CHAT_AUTH = new ChatAuthImpl(Minecraft.m_91087_());
    private static final MutedUserList MUTED_USER_LIST = new MutedUserList(Platform.getGameFolder().resolve("local/minetogether/mutedusers.json"));
    public static ChatState CHAT_STATE = new ChatState(MineTogether.API, CHAT_AUTH, MUTED_USER_LIST, () -> ModPackInfo.getInfo().realName, false);
    public static ChatComponent vanillaChat;
    public static MTChatComponent publicChat;
    private static boolean hasHitLoadingScreen;

    public static void init() {
        MineTogetherChat.CHAT_STATE.logChatToConsole = Config.instance().logChatToConsole | Config.instance().debugMode;
        publicChat = new MTChatComponent(ChatTarget.PUBLIC, Minecraft.m_91087_());
        ClientGuiEvent.INIT_POST.register(MineTogetherChat::onScreenOpen);
        if (Config.instance().debugMode) {
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.info", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.debug", "INFO");
            System.setProperty("net.creeperhost.minetogether.repack.net.covers1624.pircbot.logging.very_verbose", "true");
        }
        ChatStatistics.pollStats();
    }

    public static void initChat(Gui gui) {
        Minecraft mc = Minecraft.m_91087_();
        vanillaChat = gui.f_92988_;
        publicChat = new MTChatComponent(ChatTarget.PUBLIC, mc);
        if (Config.instance().chatEnabled) {
            MineTogetherChat.CHAT_STATE.ircClient.start();
        }
        MineTogetherChat.CHAT_STATE.ircClient.addChannelListener(new IrcClient.ChannelListener(){

            @Override
            public void channelJoin(IrcChannel channel) {
                if (MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel() == null) {
                    return;
                }
                if (channel == MineTogetherChat.CHAT_STATE.ircClient.getPrimaryChannel()) {
                    publicChat.attach(channel);
                    Screen screen = Minecraft.m_91087_().f_91080_;
                    if (screen instanceof ChatScreen) {
                        ChatScreen chat = (ChatScreen)screen;
                        chat.attach(channel);
                    }
                }
            }

            @Override
            public void channelLeave(IrcChannel channel) {
            }
        });
        MineTogetherChat.CHAT_STATE.profileManager.addListener(mc, (m, e) -> m.m_18707_(() -> {
            if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ADDED) {
                ProfileManager.FriendRequest fr = (ProfileManager.FriendRequest)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)new TextComponent(fr.from.getDisplayName() + " has sent you a friend request"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_REQUEST_ACCEPTED) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)new TextComponent(fr.getDisplayName() + " has accepted your friend request"), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_ONLINE && Config.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)new TextComponent(fr.getFriendName() + " Is now online."), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_25));
            } else if (e.type == ProfileManager.EventType.FRIEND_OFFLINE && Config.instance().friendNotifications) {
                Profile fr = (Profile)e.data;
                MineTogetherChat.addToast(new SimpleToast((Component)new TextComponent(fr.getFriendName() + " Is now offline."), (Component)new TextComponent(" "), Constants.MINETOGETHER_LOGO_25));
            }
        }));
        if (!Config.instance().firstConnect.equalsIgnoreCase(CHAT_AUTH.getHash()) && MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile().hasAccount()) {
            Config.instance().firstConnect = CHAT_AUTH.getHash();
            Config.save();
        }
    }

    private static void addToast(Toast toast) {
        if (hasHitLoadingScreen) {
            Minecraft.m_91087_().m_91300_().m_94922_(toast);
        }
    }

    public static Profile getOurProfile() {
        return MineTogetherChat.CHAT_STATE.profileManager.getOwnProfile();
    }

    private static void onScreenOpen(Screen screen, ScreenAccess screenAccess) {
        if (screen instanceof TitleScreen) {
            if (!hasHitLoadingScreen) {
                hasHitLoadingScreen = true;
            }
            if (Config.instance().mainMenuButtons) {
                MineTogetherChat.addMenuButtons(screen);
            }
        } else if (screen instanceof PauseScreen && Config.instance().pauseScreenButtons) {
            MineTogetherChat.addMenuButtons(screen);
        }
    }

    private static void addMenuButtons(Screen screen) {
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)new Button(screen.f_96543_ - 105, 5, 100, 20, (Component)new TranslatableComponent("minetogether:button.friends"), e -> Minecraft.m_91087_().m_91152_((Screen)new FriendsListScreen(screen))));
        boolean chatEnabled = Config.instance().chatEnabled;
        ScreenHooks.addRenderableWidget((Screen)screen, (AbstractWidget)new IconButton(screen.f_96543_ - 125, 5, chatEnabled ? 1 : 3, Constants.WIDGETS_SHEET, e -> Minecraft.m_91087_().m_91152_(chatEnabled ? new ChatScreen(screen) : new SettingsScreen(screen))));
    }

    public static boolean isNewUser() {
        if (MineTogetherChat.getOurProfile().hasAccount()) {
            return false;
        }
        return !Config.instance().firstConnect.equalsIgnoreCase(CHAT_AUTH.getHash());
    }

    public static void setNewUserResponded() {
        Config.instance().firstConnect = CHAT_AUTH.getHash();
        Config.save();
    }

    public static void disableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.stop();
    }

    public static void enableChat() {
        MineTogetherChat.CHAT_STATE.ircClient.start();
    }

    public static void setTarget(ChatTarget target) {
        Config.instance().selectedTab = target;
        Config.save();
    }

    public static ChatTarget getTarget() {
        return Config.instance().chatEnabled ? Config.instance().selectedTab : ChatTarget.VANILLA;
    }

    static {
        hasHitLoadingScreen = false;
    }
}

